CREATE TABLE `categoria_gasto` (
   `id` int(11) NOT NULL AUTO_INCREMENT,
   `nombre` varchar(200) NOT NULL,
   `fecha_registro` timestamp NOT NULL,
   `usuario_registro` varchar(50) NOT NULL,
   `pc_registro` varchar(50) NOT NULL,
   `fecha_edicion` timestamp NOT NULL,
   `usuario_edicion` varchar(50) NOT NULL,
   `pc_edicion` varchar(50) NOT NULL,
   `activo` smallint(1) NOT NULL,
   PRIMARY KEY (`id`)
 )  ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;


 CREATE TABLE `subcategoria_gasto` (
   `id` int(11) NOT NULL AUTO_INCREMENT,
   `categoria_gasto_id` int(11) NOT NULL,
   `nombre` varchar(200) NOT NULL,
   `fecha_registro` timestamp NOT NULL,
   `usuario_registro` varchar(50) NOT NULL,
   `pc_registro` varchar(50) NOT NULL,
   `fecha_edicion` timestamp NOT NULL,
   `usuario_edicion` varchar(50) NOT NULL,
   `pc_edicion` varchar(50) NOT NULL,
   `activo` smallint(1) NOT NULL,
   PRIMARY KEY (`id`),
   KEY `fk_categoria_subcategoria_idx` (`categoria_gasto_id`),
   CONSTRAINT `fk_categoria_subcategoria` FOREIGN KEY (`categoria_gasto_id`) REFERENCES `categoria_gasto` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
 )  ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

 CREATE TABLE `gasto` (
   `id` int(11) NOT NULL AUTO_INCREMENT,
   `categoria_gasto_id` int(11) NOT NULL,
   `subcategoria_gasto_id` int(11) NOT NULL,
   `moneda_id` int(11) NOT NULL,
   `detalle` varchar(200) NOT NULL,
   `fecha` timestamp NOT NULL,
   `tipo_cambio` decimal(18,3) NOT NULL,
   `monto` decimal(18,6) NOT NULL,
   `fecha_registro` timestamp NOT NULL,
   `usuario_registro` varchar(50) NOT NULL,
   `pc_registro` varchar(50) NOT NULL,
   `fecha_edicion` timestamp NOT NULL,
   `usuario_edicion` varchar(50) NOT NULL,
   `pc_edicion` varchar(50) NOT NULL,
   `activo` smallint(1) NOT NULL,
   PRIMARY KEY (`id`),
   KEY `fk_categoria_gasto_id_idx` (`categoria_gasto_id`),
   KEY `fk_subcategoria_gasto_id_idx` (`subcategoria_gasto_id`),
   CONSTRAINT `fk_categoria_gasto_id` FOREIGN KEY (`categoria_gasto_id`) REFERENCES `categoria_gasto` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
   CONSTRAINT `fk_subcategoria_gasto_id` FOREIGN KEY (`subcategoria_gasto_id`) REFERENCES `subcategoria_gasto` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
 )  ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_listarControlGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarControlGasto`(
	IN `p_idGasto` INT, 
    IN `p_fechaInicio` DATE, 
    IN `p_fechaFin` DATE, 
    IN `p_idCategoria` INT,
    IN `p_idSubcategoria` INT,
    IN `p_tipoOperacion` INT 
)
BEGIN     
	IF p_tipoOperacion = 1 
		THEN  
			SELECT
					G.id, 					
					G.moneda_id, 
					M2.descripcion AS moneda_descripcion,
					G.categoria_gasto_id,
                    CG.nombre AS categoria_nombre,
                    G.subcategoria_gasto_id,
                    SG.nombre AS subcategoria_nombre,
                    G.fecha,
                    G.detalle,
                    G.monto
			FROM 	GASTO G					
					INNER JOIN MULTITABLA M2
						ON M2.valor = G.moneda_id 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN CATEGORIA_GASTO CG
						ON CG.id = G.categoria_gasto_id
                        AND CG.activo = 1
					INNER JOIN SUBCATEGORIA_GASTO SG
						ON SG.id = G.subcategoria_gasto_id
                        AND SG.activo = 1
			WHERE	(p_idCategoria = '0' OR p_idCategoria = G.categoria_gasto_id)
					AND (p_idSubcategoria = '0' OR p_idSubcategoria = G.subcategoria_gasto_id)
					AND (p_fechaInicio IS NULL OR p_fechaInicio <= DATE(G.fecha_registro))
					AND (p_fechaFin IS NULL OR p_fechaFin >= DATE(G.fecha_registro))
                    AND G.activo = 1
			ORDER BY G.id DESC;
			
    END	IF; 
    
    IF p_tipoOperacion = 2
		THEN  
			SELECT
					id, 					
					moneda_id, 
					categoria_gasto_id,
                    subcategoria_gasto_id,
                    DATE(fecha) as fecha,
                    detalle,
                    tipo_cambio,
                    monto
			FROM 	GASTO
			WHERE	id = p_idGasto
                    AND activo = 1;
			
    END	IF; 
END$$

DELIMITER ;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_insertUpdateGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateGasto`(
	IN `p_idGasto` INT, 
    IN `p_idCategoria` INT,
    IN `p_idSubcategoria` INT,
    IN `p_detalle` VARCHAR(200),
    IN `p_fecha` DATE, 
    IN `p_idMoneda` INT,
    IN `p_tipoCambio` DECIMAL(18,3),
    IN `p_monto` DECIMAL(18,6),
    IN `p_usuarioRegistro` VARCHAR(50)
)
BEGIN   
    
	IF p_idGasto IS NULL OR p_idGasto = ''
		THEN       	
			
            INSERT INTO GASTO
								(categoria_gasto_id,
								subcategoria_gasto_id,
								moneda_id,
								detalle,
								fecha,
								tipo_cambio,
								monto,
								fecha_registro,
								usuario_registro,
								pc_registro,
								fecha_edicion,
								usuario_edicion,
								pc_edicion,
								activo)
						VALUES
								(p_idCategoria,
								p_idSubcategoria,
								p_idMoneda,
								p_detalle,
								p_fecha,
								p_tipoCambio,
								p_monto,
								NOW(),
								p_usuarioRegistro,
								@@hostname,
								NOW(),
								p_usuarioRegistro,
								@@hostname,
								1);

			SELECT 	1 AS 'tipoRespuesta', 
					'Se guardó correctamente.' as respuesta;
	ELSE
			UPDATE 	GASTO
			SET
					categoria_gasto_id = p_idCategoria,
					subcategoria_gasto_id = p_idSubcategoria,
					moneda_id = p_idMoneda,
					detalle = p_detalle,
					fecha = p_fecha,
					tipo_cambio = p_tipoCambio,
					monto = p_monto,
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
					pc_edicion = @@hostname
			WHERE 	id = p_idGasto;
			
			SELECT 	1 AS 'tipoRespuesta', 
					'Se editó correctamente.' as respuesta;
    END	IF; 
END$$

DELIMITER ;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_insertUpdateCategoriaGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCategoriaGasto`(
	IN `p_idCategoriaGasto` INT, 
    IN `p_nombreCategoria` VARCHAR(200),
    IN `p_usuarioRegistro` VARCHAR(50) 
)
BEGIN   
    
	IF p_idCategoriaGasto IS NULL OR p_idCategoriaGasto = ''
		THEN       	
			IF EXISTS (SELECT id FROM CATEGORIA_GASTO WHERE trim(nombre) = trim(p_nombreCategoria) and activo <> 0) 
				THEN
					SELECT	0 AS tipoRespuesta, 
							'Ya existe una categoría con este nombre !' AS respuesta;
			ELSE
            
				INSERT INTO categoria_gasto	(nombre,
											fecha_registro,
											usuario_registro, 
                                            pc_registro,
											fecha_edicion,
											usuario_edicion,
                                            pc_edicion,
											activo)
									VALUES	(p_nombreCategoria,
											NOW(),
											p_usuarioRegistro,
                                            @@hostname,
											NOW(),
											p_usuarioRegistro,
                                            @@hostname,
											1);

				SELECT 	1 AS 'tipoRespuesta', 
						'La categoría se guardó correctamente.' as respuesta,
                        LAST_INSERT_ID() AS id;
			END	IF;
	ELSE
			UPDATE 	categoria_gasto
			SET		nombre = p_nombreCategoria,
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
                    pc_edicion = @@hostname
			WHERE 	id = p_idCategoriaGasto;							
			
			SELECT 	1 AS 'tipoRespuesta', 
					'La categoría se editó correctamente.' as respuesta,
                    0 AS id;
    END	IF; 
END$$

DELIMITER ;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_listarSubcategoriasGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarSubcategoriasGasto`(
	IN `p_idCategoriaGasto` INT, 
    IN `p_idSubcategoriaGasto` INT,
    IN `p_tipoOperacion` INT)
BEGIN     
	IF p_tipoOperacion = 1 THEN       
		
        SELECT	CG.id AS categoria_id,
				CG.nombre AS categoria_nombre, 
                SG.id AS subcategoria_id,
                SG.nombre AS subcategoria_nombre
        FROM	CATEGORIA_GASTO CG
				INNER JOIN SUBCATEGORIA_GASTO SG
					ON SG.categoria_gasto_id = CG.id
        WHERE	CG.id = p_idCategoriaGasto
				AND CG.activo = 1
				AND SG.activo = 1;
        
    END	IF;  
    
    IF p_tipoOperacion = 2 THEN  
		SELECT 
				id, 
				nombre,
				numero_cuotas,
                frecuencia,
				tipo_frecuencia_id,   
				interes,
				activo
		FROM 	FORMA_PAGO
        WHERE 	id = p_idFormaPago;
    END	IF; 
   
END$$

DELIMITER ;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_listarCategoriasGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarCategoriasGasto`(
	IN `p_idCategoriaGasto` INT, 
    IN `p_tipoOperacion` INT)
BEGIN    
	IF p_tipoOperacion = 1 THEN       
		
        SELECT	id,
				nombre AS categoria_nombre
        FROM	CATEGORIA_GASTO
        WHERE	activo = 1; 
        
    END	IF;  
    
    IF p_tipoOperacion = 2 THEN  
		SELECT 
				id, 
				nombre,
				numero_cuotas,
                frecuencia,
				tipo_frecuencia_id,   
				interes,
				activo
		FROM 	FORMA_PAGO
        WHERE 	id = p_idFormaPago;
    END	IF; 
   
END$$

DELIMITER ;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_listarSubcategoriasGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarSubcategoriasGasto`(
	IN `p_idCategoriaGasto` INT, 
    IN `p_idSubcategoriaGasto` INT,
    IN `p_tipoOperacion` INT)
BEGIN     
	IF p_tipoOperacion = 1 THEN       
		
        SELECT	CG.id AS categoria_id,
				CG.nombre AS categoria_nombre,
                SG.id AS subcategoria_id, 
                SG.nombre AS subcategoria_nombre
        FROM	CATEGORIA_GASTO CG
				INNER JOIN SUBCATEGORIA_GASTO SG
					ON SG.categoria_gasto_id = CG.id
        WHERE	CG.id = p_idCategoriaGasto
				AND CG.activo = 1
				AND SG.activo = 1;
        
    END	IF;  
    
    IF p_tipoOperacion = 2 THEN  
		SELECT 
				id, 
				nombre,
				numero_cuotas,
                frecuencia,
				tipo_frecuencia_id,   
				interes,
				activo
		FROM 	FORMA_PAGO
        WHERE 	id = p_idFormaPago;
    END	IF; 
   
END$$

DELIMITER ;

USE `erp_targox`;
DROP procedure IF EXISTS `sp_eliminarCategoriaGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarCategoriaGasto`(
	IN `p_idCategoriaGasto` INT,
    IN `p_tipo` INT
)
BEGIN    

	IF p_tipo = 1 
		THEN
			UPDATE 	CATEGORIA_GASTO  
			SET		activo = 0
			WHERE	id = p_idCategoriaGasto; 
			
			SELECT 	1 AS 'tipoRespuesta',
					'La categoría se eliminó correctamente' as respuesta;
        END IF;
	
    IF p_tipo = 2 
		THEN 
			UPDATE 	SUBCATEGORIA_GASTO 
			SET		activo = 0
			WHERE	id = p_idCategoriaGasto; 
			
			SELECT 	1 AS 'tipoRespuesta',
					'La subcategoría se eliminó correctamente' as respuesta;
        END IF;
        
	IF p_tipo = 3 
		THEN 
			UPDATE 	GASTO 
			SET		activo = 0
			WHERE	id = p_idCategoriaGasto; 
			
			SELECT 	1 AS 'tipoRespuesta',
					'El gasto se eliminó correctamente' as respuesta;
        END IF;
                        
END$$


USE `erp_targox`;
DROP procedure IF EXISTS `sp_insertUpdateSubcategoriaGasto`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateSubcategoriaGasto`(
	IN `p_idCategoriaGasto` INT,
    IN `p_idSubcategoriaGasto` INT, 
    IN `p_nombreSubcategoria` VARCHAR(200),
    IN `p_usuarioRegistro` VARCHAR(50) 
)
BEGIN   
     
	IF p_idSubcategoriaGasto IS NULL OR p_idSubcategoriaGasto = ''
		THEN       	
			IF EXISTS (SELECT id FROM SUBCATEGORIA_GASTO WHERE trim(nombre) = trim(p_nombreSubcategoria) AND categoria_gasto_id = p_idCategoriaGasto AND activo <> 0) 
				THEN
					SELECT	0 AS tipoRespuesta, 
							'Ya existe una subcategoría con este nombre !' AS respuesta;
			ELSE

				INSERT INTO subcategoria_gasto
												(categoria_gasto_id,
												nombre,
												fecha_registro,
												usuario_registro,
												pc_registro,
												fecha_edicion,
												usuario_edicion,
												pc_edicion,
												activo)
										VALUES
												(p_idCategoriaGasto,
												p_nombreSubcategoria,
												NOW(),
												p_usuarioRegistro,
												@@hostname,
												NOW(),
												p_usuarioRegistro,
												@@hostname,
												1);
                                                
				SELECT 	1 AS 'tipoRespuesta', 
						'La subcategoría se guardó correctamente.' as respuesta,
                        LAST_INSERT_ID() AS id;
			END	IF;
	ELSE
			
            UPDATE	subcategoria_gasto
			SET
					categoria_gasto_id = p_idCategoriaGasto,
					nombre = p_nombreSubcategoria,
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
					pc_edicion = @@hostname
			WHERE 	id = p_idSubcategoriaGasto;						
			
			SELECT 	1 AS 'tipoRespuesta', 
					'La subcategoría se editó correctamente.' as respuesta;
    END	IF; 
END$$

DELIMITER ;

